/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
function rgb2hex(orig){var rgb=orig.replace(/\s/g,'').match(/^rgba?\((\d+),(\d+),(\d+)/i);return (rgb&&rgb.length===4)?"#"+("0"+parseInt(rgb[1],10).toString(16)).slice(-2)+("0"+parseInt(rgb[2],10).toString(16)).slice(-2)+("0"+parseInt(rgb[3],10).toString(16)).slice(-2):orig;}var getContrast=function(hexcolor){if(hexcolor.slice(0,1)==='#')hexcolor=hexcolor.slice(1);if(hexcolor.length===3)hexcolor=hexcolor.split('').map(function(hex){return hex+hex;}).join('');var r=parseInt(hexcolor.substr(0,2),16);var g=parseInt(hexcolor.substr(2,2),16);var b=parseInt(hexcolor.substr(4,2),16);var yiq=((r*299)+(g*587)+(b*114))/1000;return (yiq>=128)?'dark':'light';};;
(function($,Drupal,once){"use strict";Drupal.behaviors.backgroundColorLayoutBuilderForm={attach:function(context){once('blb_bg-color',".fieldgroup.field-background-color input[type=radio]",context).forEach(function(value,i){if($(value).val()!='_none'){$(value).next('label').addClass($(value).val());var bgColor=$(value).next('label').css('background-color');var bgColorHex=rgb2hex(bgColor);var bgColorContrast=getContrast(bgColorHex);$(value).next('label').addClass('bs_yiq-'+bgColorContrast);}});$(".fieldgroup.field-background-color .fieldset-wrapper label",context).on('click',function(){$(this).parents('.fieldset-wrapper').find('label').removeClass('active');$(this).parents('.fieldset-wrapper').addClass('style-selected').find('input').prop("checked",false);if($(this).hasClass('_none'))$(this).parents('.fieldset-wrapper').removeClass('style-selected');});$(".fieldgroup.field-background-color .fieldset-wrapper input:radio",context).each(function(){$(this).closest('.radio').find('label').addClass($(this).val());var checked=$(this).prop("checked");if(typeof checked!==typeof undefined&&checked!==false)$(this).closest('.radio').find('label').addClass('active');});}};})(jQuery,Drupal,once);;
(function($,Drupal,once){"use strict";Drupal.behaviors.textColorLayoutBuilderForm={attach:function(context){once('blb_text-color',".fieldgroup.field-text-color input[type=radio]",context).forEach(function(value,i){$(value).next('label').addClass($(value).val());if($(value).val()!='_none'){var label_color=$(value).next('label').css('color');$(value).next('label').css('background-color',label_color);var bgColor=$(value).next('label').css('background-color');var bgColorHex=rgb2hex(bgColor);var bgColorContrast=getContrast(bgColorHex);$(value).next('label').addClass('bs_yiq-'+bgColorContrast);}});$(".fieldgroup.field-text-color .fieldset-wrapper label",context).on('click',function(){$(this).parents('.fieldset-wrapper').find('label').removeClass('active');if($(this).hasClass('_none'))$(this).parents('.fieldset-wrapper').removeClass('style-selected');});$(".fieldgroup.field-text-color .fieldset-wrapper input:radio",context).each(function(){$(this).closest('.radio').find('label').addClass($(this).val());var checked=$(this).prop("checked");if(typeof checked!==typeof undefined&&checked!==false)$(this).closest('.radio').find('label').addClass('active');});}};})(jQuery,Drupal,once);;
(function($,Drupal,once){"use strict";Drupal.behaviors.spacingPreview={attach:function(context,settings){var spacing=settings.bootstrap_styles.spacing;var breakpoints=settings.bootstrap_styles.breakpoints;var padding_box_shadow=$('.spacing-preview .padding-box').css('box-shadow');var margin_box_shadow=$('.spacing-preview .margin-box').css('box-shadow');var box_shadow='0 0 0 1.5rem';function calcPadding(){var padding_val=$('input.bs-field-padding').val();var padding_left_val=$('input.bs-field-padding-left').val();var padding_top_val=$('input.bs-field-padding-top').val();var padding_right_val=$('input.bs-field-padding-right').val();var padding_bottom_val=$('input.bs-field-padding-bottom').val();var padding_classes='';var padding_class=spacing.padding_classes_options.padding[padding_val];if(padding_class!='_none')padding_classes+=padding_class+' ';var padding_left_class=spacing.padding_classes_options.padding_left[padding_left_val];if(padding_left_class!='_none')padding_classes+=padding_left_class+' ';var padding_top_class=spacing.padding_classes_options.padding_top[padding_top_val];if(padding_top_class!='_none')padding_classes+=padding_top_class+' ';var padding_right_class=spacing.padding_classes_options.padding_right[padding_right_val];if(padding_right_class!='_none')padding_classes+=padding_right_class+' ';var padding_bottom_class=spacing.padding_classes_options.padding_bottom[padding_bottom_val];if(padding_bottom_class!='_none')padding_classes+=padding_bottom_class+' ';padding_classes+=getActiveBreakpointPaddingClasses();$('#bs_spacing_preview_calc').removeClass();$('#bs_spacing_preview_calc').addClass(padding_classes);$('.spacing-preview .padding-left').text(parseInt($('#bs_spacing_preview_calc').css('padding-left')));$('.spacing-preview .padding-top').text(parseInt($('#bs_spacing_preview_calc').css('padding-top')));$('.spacing-preview .padding-right').text(parseInt($('#bs_spacing_preview_calc').css('padding-right')));$('.spacing-preview .padding-bottom').text(parseInt($('#bs_spacing_preview_calc').css('padding-bottom')));}function getActiveBreakpointPaddingClasses(){var padding_classes='';var active_breakpoint=$('.bs_responsive_spacing input:checked').val();if(typeof active_breakpoint!=='undefined'){var i;var padding_classes='';for(i=0;i<breakpoints.length;i++)if(active_breakpoint==breakpoints[i]){var padding_val=$('input.bs-field-padding-'+breakpoints[i]).val();var padding_left_val=$('input.bs-field-padding-left-'+breakpoints[i]).val();var padding_top_val=$('input.bs-field-padding-top-'+breakpoints[i]).val();var padding_right_val=$('input.bs-field-padding-right-'+breakpoints[i]).val();var padding_bottom_val=$('input.bs-field-padding-bottom-'+breakpoints[i]).val();var padding_class=spacing.padding_classes_options['padding_'+breakpoints[i]][padding_val];if(padding_class!='_none')padding_classes+=padding_class+' ';var padding_left_class=spacing.padding_classes_options['padding_left_'+breakpoints[i]][padding_left_val];if(padding_left_class!='_none')padding_classes+=padding_left_class+' ';var padding_top_class=spacing.padding_classes_options['padding_top_'+breakpoints[i]][padding_top_val];if(padding_top_class!='_none')padding_classes+=padding_top_class+' ';var padding_right_class=spacing.padding_classes_options['padding_right_'+breakpoints[i]][padding_right_val];if(padding_right_class!='_none')padding_classes+=padding_right_class+' ';var padding_bottom_class=spacing.padding_classes_options['padding_bottom_'+breakpoints[i]][padding_bottom_val];if(padding_bottom_class!='_none')padding_classes+=padding_bottom_class+' ';}}return padding_classes;}function calcMargin(){var margin_val=$('input.bs-field-margin').val();var margin_left_val=$('input.bs-field-margin-left').val();var margin_top_val=$('input.bs-field-margin-top').val();var margin_right_val=$('input.bs-field-margin-right').val();var margin_bottom_val=$('input.bs-field-margin-bottom').val();var margin_classes='';var margin_class=spacing.margin_classes_options.margin[margin_val];if(margin_class!='_none')margin_classes+=margin_class+' ';var margin_left_class=spacing.margin_classes_options.margin_left[margin_left_val];if(margin_left_class!='_none')margin_classes+=margin_left_class+' ';var margin_top_class=spacing.margin_classes_options.margin_top[margin_top_val];if(margin_top_class!='_none')margin_classes+=margin_top_class+' ';var margin_right_class=spacing.margin_classes_options.margin_right[margin_right_val];if(margin_right_class!='_none')margin_classes+=margin_right_class+' ';var margin_bottom_class=spacing.margin_classes_options.margin_bottom[margin_bottom_val];if(margin_bottom_class!='_none')margin_classes+=margin_bottom_class+' ';$('#bs_spacing_preview_calc').removeClass();$('#bs_spacing_preview_calc').addClass(margin_classes);$('.spacing-preview .margin-left').text(parseInt($('#bs_spacing_preview_calc').css('margin-left')));$('.spacing-preview .margin-top').text(parseInt($('#bs_spacing_preview_calc').css('margin-top')));$('.spacing-preview .margin-right').text(parseInt($('#bs_spacing_preview_calc').css('margin-right')));$('.spacing-preview .margin-bottom').text(parseInt($('#bs_spacing_preview_calc').css('margin-bottom')));}calcPadding();calcMargin();$('input[class^="bs-field-padding"], .bs_responsive_spacing input',context).on('change',function(){calcPadding();});$('input[class^="bs-field-padding"]',context).on('focus',function(){var panel_bg=$(this).parents('details').find('summary').css('background-color');var inactive_box_shadow=box_shadow+' '+panel_bg;$('.spacing-preview .margin-box').css('box-shadow',inactive_box_shadow);$('.spacing-preview .padding-box').addClass('bs-adjusting');});$('input[class^="bs-field-padding"]',context).on('focusout',function(){$('.spacing-preview .margin-box').css('box-shadow',margin_box_shadow);$('.spacing-preview .padding-box').removeClass('bs-adjusting');});$('input[class^="bs-field-margin"]',context).on('change',function(){calcMargin();});$('input[class^="bs-field-margin"]',context).on('focus',function(){var panel_bg=$(this).parents('details').find('summary').css('background-color');var inactive_box_shadow=box_shadow+' '+panel_bg;$('.spacing-preview .padding-box').css('box-shadow',inactive_box_shadow);$('.spacing-preview .margin-box').addClass('bs-adjusting');});$('input[class^="bs-field-margin"]',context).on('focusout',function(){$('.spacing-preview .padding-box').css('box-shadow',padding_box_shadow);$('.spacing-preview .margin-box').removeClass('bs-adjusting');});}};})(jQuery,Drupal,once);;
(function($,Drupal,debounce){$.fn.drupalGetSummary=function(){const callback=this.data('summaryCallback');if(!this[0]||!callback)return '';const result=callback(this[0]);return result?result.trim():'';};$.fn.drupalSetSummary=function(callback){const self=this;if(typeof callback!=='function'){const val=callback;callback=function(){return val;};}return (this.data('summaryCallback',callback).off('formUpdated.summary').on('formUpdated.summary',()=>{self.trigger('summaryUpdated');}).trigger('summaryUpdated'));};Drupal.behaviors.formSingleSubmit={attach(){function onFormSubmit(e){const $form=$(e.currentTarget);const formValues=new URLSearchParams(new FormData(e.target)).toString();const previousValues=$form.attr('data-drupal-form-submit-last');if(previousValues===formValues)e.preventDefault();else $form.attr('data-drupal-form-submit-last',formValues);}$(once('form-single-submit','body')).on('submit.singleSubmit','form:not([method~="GET"])',onFormSubmit);}};function triggerFormUpdated(element){$(element).trigger('formUpdated');}function fieldsList(form){return [].map.call(form.querySelectorAll('[name][id]'),(el)=>el.id);}Drupal.behaviors.formUpdated={attach(context){const $context=$(context);const contextIsForm=context.tagName==='FORM';const $forms=$(once('form-updated',contextIsForm?$context:$context.find('form')));let formFields;if($forms.length)$.makeArray($forms).forEach((form)=>{const events='change.formUpdated input.formUpdated ';const eventHandler=debounce((event)=>{triggerFormUpdated(event.target);},300);formFields=fieldsList(form).join(',');form.setAttribute('data-drupal-form-fields',formFields);$(form).on(events,eventHandler);});if(contextIsForm){formFields=fieldsList(context).join(',');const currentFields=$(context).attr('data-drupal-form-fields');if(formFields!==currentFields)triggerFormUpdated(context);}},detach(context,settings,trigger){const $context=$(context);const contextIsForm=context.tagName==='FORM';if(trigger==='unload')once.remove('form-updated',contextIsForm?$context:$context.find('form')).forEach((form)=>{form.removeAttribute('data-drupal-form-fields');$(form).off('.formUpdated');});}};Drupal.behaviors.fillUserInfoFromBrowser={attach(context,settings){const userInfo=['name','mail','homepage'];const $forms=$(once('user-info-from-browser','[data-user-info-from-browser]'));if($forms.length)userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);const browserData=localStorage.getItem(`Drupal.visitor.${info}`);if(!$element.length)return;const emptyValue=$element[0].value==='';const defaultValue=$element.attr('data-drupal-default-value')===$element[0].value;if(browserData&&(emptyValue||defaultValue))$element.each(function(index,item){item.value=browserData;});});$forms.on('submit',()=>{userInfo.forEach((info)=>{const $element=$forms.find(`[name=${info}]`);if($element.length)localStorage.setItem(`Drupal.visitor.${info}`,$element[0].value);});});}};const handleFragmentLinkClickOrHashChange=(e)=>{let url;if(e.type==='click')url=e.currentTarget.location?e.currentTarget.location:e.currentTarget;else url=window.location;const hash=url.hash.substring(1);if(hash){const $target=$(`#${hash}`);$('body').trigger('formFragmentLinkClickOrHashChange',[$target]);setTimeout(()=>$target.trigger('focus'),300);}};const debouncedHandleFragmentLinkClickOrHashChange=debounce(handleFragmentLinkClickOrHashChange,300,true);$(window).on('hashchange.form-fragment',debouncedHandleFragmentLinkClickOrHashChange);$(document).on('click.form-fragment','a[href*="#"]',debouncedHandleFragmentLinkClickOrHashChange);})(jQuery,Drupal,Drupal.debounce);;
(($,Drupal)=>{function DetailsSummarizedContent(node){this.$node=$(node);this.setupSummary();}$.extend(DetailsSummarizedContent,{instances:[]});$.extend(DetailsSummarizedContent.prototype,{setupSummary(){this.$detailsSummarizedContentWrapper=$(Drupal.theme('detailsSummarizedContentWrapper'));this.$node.on('summaryUpdated',this.onSummaryUpdated.bind(this)).trigger('summaryUpdated').find('> summary').append(this.$detailsSummarizedContentWrapper);},onSummaryUpdated(){const text=this.$node.drupalGetSummary();this.$detailsSummarizedContentWrapper.html(Drupal.theme('detailsSummarizedContentText',text));}});Drupal.behaviors.detailsSummary={attach(context){DetailsSummarizedContent.instances=DetailsSummarizedContent.instances.concat(once('details','details',context).map((details)=>new DetailsSummarizedContent(details)));}};Drupal.DetailsSummarizedContent=DetailsSummarizedContent;Drupal.theme.detailsSummarizedContentWrapper=()=>`<span class="summary"></span>`;Drupal.theme.detailsSummarizedContentText=(text)=>text?` (${text})`:'';})(jQuery,Drupal);;
(function($,Drupal){Drupal.behaviors.detailsAria={attach(){$(once('detailsAria','body')).on('click.detailsAria','summary',(event)=>{const $summary=$(event.currentTarget);const open=$(event.currentTarget.parentNode).attr('open')==='open'?'false':'true';$summary.attr({'aria-expanded':open});});}};})(jQuery,Drupal);;
(function($){const handleFragmentLinkClickOrHashChange=(e,$target)=>{$target.parents('details').not('[open]').find('> summary').trigger('click');};$('body').on('formFragmentLinkClickOrHashChange.details',handleFragmentLinkClickOrHashChange);window.addEventListener('invalid',(event)=>{if(event.target.matches('details input[required]'))handleFragmentLinkClickOrHashChange(event,$(event.target));},{capture:true});})(jQuery);;
(function($,Drupal){const states={postponed:[]};Drupal.states=states;function invert(a,invertState){return invertState&&typeof a!=='undefined'?!a:a;}function compare(a,b){if(a===b)return typeof a==='undefined'?a:true;return typeof a==='undefined'||typeof b==='undefined';}function ternary(a,b){if(typeof a==='undefined')return b;if(typeof b==='undefined')return a;return a&&b;}Drupal.behaviors.states={attach(context,settings){const elements=once('states','[data-drupal-states]',context);const il=elements.length;for(let i=0;i<il;i++){const config=JSON.parse(elements[i].getAttribute('data-drupal-states'));Object.keys(config||{}).forEach((state)=>{new states.Dependent({element:$(elements[i]),state:states.State.sanitize(state),constraints:config[state]});});}while(states.postponed.length)states.postponed.shift()();}};states.Dependent=function(args){$.extend(this,{values:{},oldValue:null},args);this.dependees=this.getDependees();Object.keys(this.dependees||{}).forEach((selector)=>{this.initializeDependee(selector,this.dependees[selector]);});};states.Dependent.comparisons={RegExp(reference,value){return reference.test(value);},Function(reference,value){return reference(value);},Array(reference,value){if(!Array.isArray(value))return false;return JSON.stringify(reference.sort())===JSON.stringify(value.sort());},Number(reference,value){return typeof value==='string'?compare(reference.toString(),value):compare(reference,value);}};states.Dependent.prototype={initializeDependee(selector,dependeeStates){this.values[selector]={};Object.keys(dependeeStates).forEach((i)=>{let state=dependeeStates[i];if($.inArray(state,dependeeStates)===-1)return;state=states.State.sanitize(state);this.values[selector][state.name]=null;$(selector).on(`state:${state}`,{selector,state},(e)=>{this.update(e.data.selector,e.data.state,e.value);});new states.Trigger({selector,state});});},compare(reference,selector,state){const value=this.values[selector][state.name];if(reference.constructor.name in states.Dependent.comparisons)return states.Dependent.comparisons[reference.constructor.name](reference,value);return compare(reference,value);},update(selector,state,value){if(value!==this.values[selector][state.name]){this.values[selector][state.name]=value;this.reevaluate();}},reevaluate(){let value=this.verifyConstraints(this.constraints);if(value!==this.oldValue){this.oldValue=value;value=invert(value,this.state.invert);this.element.trigger({type:`state:${this.state}`,value,trigger:true});}},verifyConstraints(constraints,selector){let result;if(Array.isArray(constraints)){const hasXor=$.inArray('xor',constraints)===-1;const len=constraints.length;for(let i=0;i<len;i++)if(constraints[i]!=='xor'){const constraint=this.checkConstraints(constraints[i],selector,i);if(constraint&&(hasXor||result))return hasXor;result=result||constraint;}}else{if($.isPlainObject(constraints)){for(const n in constraints)if(constraints.hasOwnProperty(n)){result=ternary(result,this.checkConstraints(constraints[n],selector,n));if(result===false)return false;}}}return result;},checkConstraints(value,selector,state){if(typeof state!=='string'||/[0-9]/.test(state[0]))state=null;else{if(typeof selector==='undefined'){selector=state;state=null;}}if(state!==null){state=states.State.sanitize(state);return invert(this.compare(value,selector,state),state.invert);}return this.verifyConstraints(value,selector);},getDependees(){const cache={};const _compare=this.compare;this.compare=function(reference,selector,state){(cache[selector]||(cache[selector]=[])).push(state.name);};this.verifyConstraints(this.constraints);this.compare=_compare;return cache;}};states.Trigger=function(args){$.extend(this,args);if(this.state in states.Trigger.states){this.element=$(this.selector);if(!this.element.data(`trigger:${this.state}`))this.initialize();}};states.Trigger.prototype={initialize(){const trigger=states.Trigger.states[this.state];if(typeof trigger==='function')trigger.call(window,this.element);else Object.keys(trigger||{}).forEach((event)=>{this.defaultTrigger(event,trigger[event]);});this.element.data(`trigger:${this.state}`,true);},defaultTrigger(event,valueFn){let oldValue=valueFn.call(this.element);this.element.on(event,function(e){const value=valueFn.call(this.element,e);if(oldValue!==value){this.element.trigger({type:`state:${this.state}`,value,oldValue});oldValue=value;}}.bind(this));states.postponed.push(function(){this.element.trigger({type:`state:${this.state}`,value:oldValue,oldValue:null});}.bind(this));}};states.Trigger.states={empty:{keyup(){return this.val()==='';},change(){return this.val()==='';}},checked:{change(){let checked=false;this.each(function(){checked=$(this).prop('checked');return !checked;});return checked;}},value:{keyup(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();},change(){if(this.length>1)return this.filter(':checked').val()||false;return this.val();}},collapsed:{collapsed(e){return typeof e!=='undefined'&&'value' in e?e.value:!this[0].hasAttribute('open');}}};states.State=function(state){this.pristine=state;this.name=state;let process=true;do{while(this.name.charAt(0)==='!'){this.name=this.name.substring(1);this.invert=!this.invert;}if(this.name in states.State.aliases)this.name=states.State.aliases[this.name];else process=false;}while(process);};states.State.sanitize=function(state){if(state instanceof states.State)return state;return new states.State(state);};states.State.aliases={enabled:'!disabled',invisible:'!visible',invalid:'!valid',untouched:'!touched',optional:'!required',filled:'!empty',unchecked:'!checked',irrelevant:'!relevant',expanded:'!collapsed',open:'!collapsed',closed:'collapsed',readwrite:'!readonly'};states.State.prototype={invert:false,toString(){return this.name;}};const $document=$(document);$document.on('state:disabled',(e)=>{const tagsSupportDisable='button, fieldset, optgroup, option, select, textarea, input';if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-disabled',e.value).find(tagsSupportDisable).addBack(tagsSupportDisable).prop('disabled',e.value);});$document.on('state:readonly',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper').toggleClass('form-readonly',e.value).find('input, textarea').prop('readonly',e.value);});$document.on('state:required',(e)=>{if(e.trigger)if(e.value){const label=`label${e.target.id?`[for=${e.target.id}]`:''}`;const $label=$(e.target).attr({required:'required'}).closest('.js-form-item, .js-form-wrapper').find(label);if(!$label.hasClass('js-form-required').length)$label.addClass('js-form-required form-required');}else $(e.target).removeAttr('required').closest('.js-form-item, .js-form-wrapper').find('label.js-form-required').removeClass('js-form-required form-required');});$document.on('state:visible',(e)=>{if(e.trigger){let $element=$(e.target).closest('.js-form-item, .js-form-submit, .js-form-wrapper');if(e.target.tagName==='A')$element=$(e.target);$element.toggle(e.value);}});$document.on('state:checked',(e)=>{if(e.trigger)$(e.target).closest('.js-form-item, .js-form-wrapper').find('input').prop('checked',e.value).trigger('change');});$document.on('state:collapsed',(e)=>{if(e.trigger)if(e.target.hasAttribute('open')===e.value)$(e.target).find('> summary').trigger('click');});})(jQuery,Drupal);;
/* @license GPL-2.0-or-later https://raw.githubusercontent.com/jquery-form/form/master/LICENSE */
(function(factory){if(typeof define==='function'&&define.amd)define(['jquery'],factory);else if(typeof module==='object'&&module.exports)module.exports=function(root,jQuery){if(typeof jQuery==='undefined')if(typeof window!=='undefined')jQuery=require('jquery');else jQuery=require('jquery')(root);factory(jQuery);return jQuery;};else factory(jQuery);}(function($){'use strict';var rCRLF=/\r?\n/g;var feature={};feature.fileapi=$('<input type="file">').get(0).files!==undefined;feature.formdata=(typeof window.FormData!=='undefined');var hasProp=!!$.fn.prop;$.fn.attr2=function(){if(!hasProp)return this.attr.apply(this,arguments);var val=this.prop.apply(this,arguments);if((val&&val.jquery)||typeof val==='string')return val;return this.attr.apply(this,arguments);};$.fn.ajaxSubmit=function(options,data,dataType,onSuccess){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this;}var method,action,url,isMsie,iframeSrc,$form=this;if(typeof options==='function')options={success:options};else if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function')options.success=onSuccess;}else{if(typeof options==='undefined')options={};}method=options.method||options.type||this.attr2('method');action=options.url||this.attr2('action');url=(typeof action==='string')?action.trim():'';url=url||window.location.href||'';if(url)url=(url.match(/^([^#]+)/)||[])[1];isMsie=/(MSIE|Trident)/.test(navigator.userAgent||'');iframeSrc=(isMsie&&/^https/i.test(window.location.href||''))?'javascript:false':'about:blank';options=$.extend(true,{url,success:$.ajaxSettings.success,type:method||$.ajaxSettings.type,iframeSrc},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this;}if(options.beforeSerialize&&options.beforeSerialize(this,options)===false){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this;}var traditional=options.traditional;if(typeof traditional==='undefined')traditional=$.ajaxSettings.traditional;var elements=[];var qx,a=this.formToArray(options.semantic,elements,options.filtering);if(options.data){var optionsData=typeof (options.data)==="function"?options.data(a):options.data;options.extraData=optionsData;qx=$.param(optionsData,traditional);}if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this;}this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this;}var q=$.param(a,traditional);if(qx)q=(q?(q+'&'+qx):qx);if(options.type.toUpperCase()==='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null;}else options.data=q;var callbacks=[];if(options.resetForm)callbacks.push(function(){$form.resetForm();});if(options.clearForm)callbacks.push(function(){$form.clearForm(options.includeHidden);});if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data,textStatus,jqXHR){var successArguments=arguments,fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(function(){oldSuccess.apply(this,successArguments);});});}else{if(options.success)if(Array.isArray(options.success))callbacks=callbacks.concat(options.success);else callbacks.push(options.success);}options.success=function(data,status,xhr){var context=options.context||this;for(var i=0,max=callbacks.length;i<max;i++)callbacks[i].apply(context,[data,status,xhr||$form,$form]);};if(options.error){var oldError=options.error;options.error=function(xhr,status,error){var context=options.context||this;oldError.apply(context,[xhr,status,error,$form]);};}if(options.complete){var oldComplete=options.complete;options.complete=function(xhr,status){var context=options.context||this;oldComplete.apply(context,[xhr,status,$form]);};}var fileInputs=$('input[type=file]:enabled',this).filter(function(){return $(this).val()!=='';});var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')===mp||$form.attr('encoding')===mp);var fileAPI=feature.fileapi&&feature.formdata;log('fileAPI :'+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;var jqxhr;if(options.iframe!==false&&(options.iframe||shouldUseFrame))if(options.closeKeepAlive)$.get(options.closeKeepAlive,function(){jqxhr=fileUploadIframe(a);});else jqxhr=fileUploadIframe(a);else if((hasFileInputs||multipart)&&fileAPI)jqxhr=fileUploadXhr(a);else jqxhr=$.ajax(options);$form.removeData('jqxhr').data('jqxhr',jqxhr);for(var k=0;k<elements.length;k++)elements[k]=null;this.trigger('form-submit-notify',[this,options]);return this;function deepSerialize(extraData){var serialized=$.param(extraData,options.traditional).split('&');var len=serialized.length;var result=[];var i,part;for(i=0;i<len;i++){serialized[i]=serialized[i].replace(/\+/g,' ');part=serialized[i].split('=');result.push([decodeURIComponent(part[0]),decodeURIComponent(part[1])]);}return result;}function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++)formdata.append(a[i].name,a[i].value);if(options.extraData){var serializedData=deepSerialize(options.extraData);for(i=0;i<serializedData.length;i++)if(serializedData[i])formdata.append(serializedData[i][0],serializedData[i][1]);}options.data=null;var s=$.extend(true,{},$.ajaxSettings,options,{contentType:false,processData:false,cache:false,type:method||'POST'});if(options.uploadProgress)s.xhr=function(){var xhr=$.ajaxSettings.xhr();if(xhr.upload)xhr.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total;if(event.lengthComputable)percent=Math.ceil(position/total*100);options.uploadProgress(event,position,total,percent);},false);return xhr;};s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){if(options.formData)o.data=options.formData;else o.data=formdata;if(beforeSend)beforeSend.call(this,xhr,o);};return $.ajax(s);}function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var deferred=$.Deferred();deferred.abort=function(status){xhr.abort(status);};if(a)for(i=0;i<elements.length;i++){el=$(elements[i]);if(hasProp)el.prop('disabled',false);else el.removeAttr('disabled');}s=$.extend(true,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+new Date().getTime();var ownerDocument=form.ownerDocument;var $body=$form.closest('body');if(s.iframeTarget){$io=$(s.iframeTarget,ownerDocument);n=$io.attr2('name');if(!n)$io.attr2('name',id);else id=n;}else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />',ownerDocument);$io.css({position:'absolute',top:'-1000px',left:'-1000px'});}io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;try{if(io.contentWindow.document.execCommand)io.contentWindow.document.execCommand('Stop');}catch(ignore){}$io.attr('src',s.iframeSrc);xhr.error=e;if(s.error)s.error.call(s.context,xhr,e,status);if(g)$.event.trigger('ajaxError',[xhr,s,e]);if(s.complete)s.complete.call(s.context,xhr,e);}};g=s.global;if(g&&$.active++===0)$.event.trigger('ajaxStart');if(g)$.event.trigger('ajaxSend',[xhr,s]);if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===false){if(s.global)$.active--;deferred.reject();return deferred;}if(xhr.aborted){deferred.reject();return deferred;}sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type==='image'){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y;}}}var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=null;try{if(frame.contentWindow)doc=frame.contentWindow.document;}catch(err){log('cannot get iframe.contentWindow document: '+err);}if(doc)return doc;try{doc=frame.contentDocument?frame.contentDocument:frame.document;}catch(err){log('cannot get iframe.contentDocument: '+err);doc=frame.document;}return doc;}var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token;}function doSubmit(){var t=$form.attr2('target'),a=$form.attr2('action'),mp='multipart/form-data',et=$form.attr('enctype')||$form.attr('encoding')||mp;form.setAttribute('target',id);if(!method||/post/i.test(method))form.setAttribute('method','POST');if(a!==s.url)form.setAttribute('action',s.url);if(!s.skipEncodingOverride&&(!method||/post/i.test(method)))$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'});if(s.timeout)timeoutHandle=setTimeout(function(){timedOut=true;cb(CLIENT_TIMEOUT_ABORT);},s.timeout);function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state&&state.toLowerCase()==='uninitialized')setTimeout(checkState,50);}catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);if(timeoutHandle)clearTimeout(timeoutHandle);timeoutHandle=undefined;}}var extraInputs=[];try{if(s.extraData)for(var n in s.extraData)if(s.extraData.hasOwnProperty(n))if($.isPlainObject(s.extraData[n])&&s.extraData[n].hasOwnProperty('name')&&s.extraData[n].hasOwnProperty('value'))extraInputs.push($('<input type="hidden" name="'+s.extraData[n].name+'">',ownerDocument).val(s.extraData[n].value).appendTo(form)[0]);else extraInputs.push($('<input type="hidden" name="'+n+'">',ownerDocument).val(s.extraData[n]).appendTo(form)[0]);if(!s.iframeTarget)$io.appendTo($body);if(io.attachEvent)io.attachEvent('onload',cb);else io.addEventListener('load',cb,false);setTimeout(checkState,15);try{form.submit();}catch(err){var submitFn=document.createElement('form').submit;submitFn.apply(form);}}finally{form.setAttribute('action',a);form.setAttribute('enctype',et);if(t)form.setAttribute('target',t);else $form.removeAttr('target');$(extraInputs).remove();}}if(s.forceSync)doSubmit();else setTimeout(doSubmit,10);var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed)return;doc=getDoc(io);if(!doc){log('cannot access response document');e=SERVER_ABORT;}if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');deferred.reject(xhr,'timeout');return;}if(e===SERVER_ABORT&&xhr){xhr.abort('server abort');deferred.reject(xhr,'error','server abort');return;}if(!doc||doc.location.href===s.iframeSrc)if(!timedOut)return;if(io.detachEvent)io.detachEvent('onload',cb);else io.removeEventListener('load',cb,false);var status='success',errMsg;try{if(timedOut)throw 'timeout';var isXml=s.dataType==='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body===null||!doc.body.innerHTML))if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return;}var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml)s.dataType='xml';xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header.toLowerCase()];};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText;}var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText;}else{if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre)xhr.responseText=pre.textContent?pre.textContent:pre.innerText;else{if(b)xhr.responseText=b.textContent?b.textContent:b.innerText;}}}}else{if(dt==='xml'&&!xhr.responseXML&&xhr.responseText)xhr.responseXML=toXml(xhr.responseText);}try{data=httpData(xhr,dt,s);}catch(err){status='parsererror';xhr.error=errMsg=(err||status);}}catch(err){log('error caught: ',err);status='error';xhr.error=errMsg=(err||status);}if(xhr.aborted){log('upload aborted');status=null;}if(xhr.status)status=((xhr.status>=200&&xhr.status<300)||xhr.status===304)?'success':'error';if(status==='success'){if(s.success)s.success.call(s.context,data,'success',xhr);deferred.resolve(xhr.responseText,'success',xhr);if(g)$.event.trigger('ajaxSuccess',[xhr,s]);}else{if(status){if(typeof errMsg==='undefined')errMsg=xhr.statusText;if(s.error)s.error.call(s.context,xhr,status,errMsg);deferred.reject(xhr,'error',errMsg);if(g)$.event.trigger('ajaxError',[xhr,s,errMsg]);}}if(g)$.event.trigger('ajaxComplete',[xhr,s]);if(g&&!--$.active)$.event.trigger('ajaxStop');if(s.complete)s.complete.call(s.context,xhr,status);callbackProcessed=true;if(s.timeout)clearTimeout(timeoutHandle);setTimeout(function(){if(!s.iframeTarget)$io.remove();else $io.attr('src',s.iframeSrc);xhr.responseXML=null;},100);}var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s);}else doc=(new DOMParser()).parseFromString(s,'text/xml');return (doc&&doc.documentElement&&doc.documentElement.nodeName!=='parsererror')?doc:null;};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=((type==='xml'||!type)&&ct.indexOf('xml')>=0),data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror')if($.error)$.error('parsererror');if(s&&s.dataFilter)data=s.dataFilter(data,type);if(typeof data==='string')if((type==='json'||!type)&&ct.indexOf('json')>=0)data=JSON.parse(data);else{if((type==='script'||!type)&&ct.indexOf('javascript')>=0)$.globalEval(data);}return data;};return deferred;}};$.fn.ajaxForm=function(options,data,dataType,onSuccess){if(typeof options==='string'||(options===false&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function')options.success=onSuccess;}options=options||{};options.delegation=options.delegation&&typeof $.fn.on==='function';if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options);});return this;}log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this;}if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this;}if(options.beforeFormUnbind)options.beforeFormUnbind(this,options);return this.ajaxFormUnbind().on('submit.form-plugin',options,doAjaxSubmit).on('click.form-plugin',options,captureSubmittingElement);};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(e.target).closest('form').ajaxSubmit(options);}}function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!$el.is('[type=submit],[type=image]')){var t=$el.closest('[type=submit]');if(t.length===0)return;target=t[0];}var form=target.form;form.clk=target;if(target.type==='image')if(typeof e.offsetX!=='undefined'){form.clk_x=e.offsetX;form.clk_y=e.offsetY;}else if(typeof $.fn.offset==='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top;}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop;}setTimeout(function(){form.clk=form.clk_x=form.clk_y=null;},100);}$.fn.ajaxFormUnbind=function(){return this.off('submit.form-plugin click.form-plugin');};$.fn.formToArray=function(semantic,elements,filtering){var a=[];if(this.length===0)return a;var form=this[0];var formId=this.attr('id');var els=(semantic||typeof form.elements==='undefined')?form.getElementsByTagName('*'):form.elements;var els2;if(els)els=$.makeArray(els);if(formId&&(semantic||/(Edge|Trident)\//.test(navigator.userAgent))){els2=$(':input[form="'+formId+'"]').get();if(els2.length)els=(els||[]).concat(els2);}if(!els||!els.length)return a;if(typeof (filtering)==="function")els=$.map(els,filtering);var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n||el.disabled)continue;if(semantic&&form.clk&&el.type==='image'){if(form.clk===el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}continue;}v=$.fieldValue(el,true);if(v&&v.constructor===Array){if(elements)elements.push(el);for(j=0,jmax=v.length;j<jmax;j++)a.push({name:n,value:v[j]});}else if(feature.fileapi&&el.type==='file'){if(elements)elements.push(el);var files=el.files;if(files.length)for(j=0;j<files.length;j++)a.push({name:n,value:files[j],type:el.type});else a.push({name:n,value:'',type:el.type});}else{if(v!==null&&typeof v!=='undefined'){if(elements)elements.push(el);a.push({name:n,value:v,type:el.type,required:el.required});}}}if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type==='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}}return a;};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic));};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n)return;var v=$.fieldValue(this,successful);if(v&&v.constructor===Array)for(var i=0,max=v.length;i<max;i++)a.push({name:n,value:v[i]});else{if(v!==null&&typeof v!=='undefined')a.push({name:this.name,value:v});}});return $.param(a);};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v==='undefined'||(v.constructor===Array&&!v.length))continue;if(Array.isArray(v))val=val.concat(v);else val.push(v);}return val;};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful==='undefined')successful=true;if(successful&&(!n||el.disabled||t==='reset'||t==='button'||(t==='checkbox'||t==='radio')&&!el.checked||(t==='submit'||t==='image')&&el.form&&el.form.clk!==el||tag==='select'&&el.selectedIndex===-1))return null;if(tag==='select'){var index=el.selectedIndex;if(index<0)return null;var a=[],ops=el.options;var one=(t==='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected&&!op.disabled){var v=op.value;if(!v)v=(op.attributes&&op.attributes.value&&!(op.attributes.value.specified))?op.text:op.value;if(one)return v;a.push(v);}}return a;}return $(el).val().replace(rCRLF,'\r\n');};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden);});};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag==='textarea')this.value='';else if(t==='checkbox'||t==='radio')this.checked=false;else if(tag==='select')this.selectedIndex=-1;else if(t==='file')if(/MSIE/.test(navigator.userAgent))$(this).replaceWith($(this).clone(true));else $(this).val('');else{if(includeHidden)if((includeHidden===true&&/hidden/.test(t))||(typeof includeHidden==='string'&&$(this).is(includeHidden)))this.value='';}});};$.fn.resetForm=function(){return this.each(function(){var el=$(this);var tag=this.tagName.toLowerCase();switch(tag){case 'input':this.checked=this.defaultChecked;case 'textarea':this.value=this.defaultValue;return true;case 'option':case 'optgroup':var select=el.parents('select');if(select.length&&select[0].multiple)if(tag==='option')this.selected=this.defaultSelected;else el.find('option').resetForm();else select.resetForm();return true;case 'select':el.find('option').each(function(i){this.selected=this.defaultSelected;if(this.defaultSelected&&!el[0].multiple){el[0].selectedIndex=i;return false;}});return true;case 'label':var forEl=$(el.attr('for'));var list=el.find('input,select,textarea');if(forEl[0])list.unshift(forEl[0]);list.resetForm();return true;case 'form':if(typeof this.reset==='function'||(typeof this.reset==='object'&&!this.reset.nodeType))this.reset();return true;default:el.find('form,input,label,select,textarea').resetForm();return true;}});};$.fn.enable=function(b){if(typeof b==='undefined')b=true;return this.each(function(){this.disabled=!b;});};$.fn.selected=function(select){if(typeof select==='undefined')select=true;return this.each(function(){var t=this.type;if(t==='checkbox'||t==='radio')this.checked=select;else{if(this.tagName.toLowerCase()==='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type==='select-one')$sel.find('option').selected(false);this.selected=select;}}});};$.fn.ajaxSubmit.debug=false;function log(){if(!$.fn.ajaxSubmit.debug)return;var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log)window.console.log(msg);else{if(window.opera&&window.opera.postError)window.opera.postError(msg);}}}));;
/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,_,Drupal,drupalSettings){"use strict";Drupal.behaviors.LayoutBuilderBlocksContentTab={attach:function(context){$('form.layout-builder-configure-block > :not(#bs_ui):not(.form-submit)').each(function(){$('form.layout-builder-configure-block > #bs_ui > #bs_tabContent > .bs_tab-pane--content').append($(this));});}};})(window.jQuery,window._,window.Drupal,window.drupalSettings);;
((Drupal)=>{Drupal.theme.checkbox=()=>`<input type="checkbox" class="form-checkbox"/>`;})(Drupal);;
(($,Drupal)=>{Drupal.behaviors.ClickToSelect={attach(context){$(once('media-library-click-to-select','.js-click-to-select-trigger',context)).on('click',(event)=>{event.preventDefault();const $input=$(event.currentTarget).closest('.js-click-to-select').find('.js-click-to-select-checkbox input');$input.prop('checked',!$input.prop('checked')).trigger('change');});$(once('media-library-click-to-select','.js-click-to-select-checkbox input',context)).on('change',({currentTarget})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('checked',$(currentTarget).prop('checked'));}).on('focus blur',({currentTarget,type})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('is-focus',type==='focus');});$(once('media-library-click-to-select-hover','.js-click-to-select-trigger, .js-click-to-select-checkbox',context)).on('mouseover mouseout',({currentTarget,type})=>{$(currentTarget).closest('.js-click-to-select').toggleClass('is-hover',type==='mouseover');});}};})(jQuery,Drupal);;
(($,Drupal)=>{Drupal.behaviors.MediaLibrarySelectAll={attach(context){const $view=$(once('media-library-select-all','.js-media-library-view[data-view-display-id="page"]',context));if($view.length&&$view.find('.js-media-library-item').length){const $checkbox=$(Drupal.theme('checkbox')).on('click',({currentTarget})=>{const $checkboxes=$(currentTarget).closest('.js-media-library-view').find('.js-media-library-item input[type="checkbox"]');$checkboxes.prop('checked',$(currentTarget).prop('checked')).trigger('change');const announcement=$(currentTarget).prop('checked')?Drupal.t('All @count items selected',{'@count':$checkboxes.length}):Drupal.t('Zero items selected');Drupal.announce(announcement);});const $label=$('<label class="media-library-select-all"></label>');$label[0].textContent=Drupal.t('Select all media');$label.prepend($checkbox);$view.find('.js-media-library-item').first().before($label);}}};})(jQuery,Drupal);;
(($,Drupal,Sortable)=>{"use strict";Drupal.behaviors.MediaLibraryFormElementEditItem={attach:function attach(context){const itemSelector='.media-library-form-element .js-media-library-item a[href]';$(once('media-library-edit',itemSelector,context)).each(function(index){var elementSettings={progress:{type:"throbber"},dialogType:"modal",dialog:{width:"80%"},dialogRenderer:null,base:$(this).attr("id"),element:this,url:$(this).attr("href"),event:"click"};Drupal.ajax(elementSettings);});}};Drupal.behaviors.MediaLibraryFormElementDisableButton={attach(context){const itemSelector='.js-media-library-open-button[data-disabled-focus="true"]';$(once('media-library-disable',itemSelector,context)).each(function(index){$(this).focus();setTimeout(()=>{$(this).attr("disabled","disabled");},50);});}};Drupal.behaviors.MediaLibraryFormElementToggleWeight={attach(context){const strings={show:Drupal.t("Show media item weights"),hide:Drupal.t("Hide media item weights")};$(once('media-library-toggle','.js-media-library-widget-toggle-weight',context)).each(function(index){$(this).on('click',(e)=>{e.preventDefault();$(e.currentTarget).toggleClass('active').text($(e.currentTarget).hasClass('active')?strings.hide:strings.show).closest('.js-media-library-widget').find('.js-media-library-item-weight').parent().toggle();}).text(strings.show);});$(once('media-library-toggle','.js-media-library-item-weight',context)).each(function(index){$(this).parent().hide();});}};Drupal.behaviors.MediaLibraryFormElementSortable={attach(context){const selection=context.querySelectorAll(".js-media-library-selection");selection.forEach((widget)=>{Sortable.create(widget,{draggable:".js-media-library-item",handle:".js-media-library-item-preview",onEnd:()=>{$(widget).children().each((index,child)=>{$(child).find(".js-media-library-item-weight").val(index);});}});});}};$.fn.setMediaUploadFieldValue=function(data,element){const currentValue=$(element).val();$(element).val(`${currentValue}${currentValue===""?"":","}${data}`);};})(jQuery,Drupal,Sortable);;
